/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.JMSBroker;
import java.util.Properties;

public class BrokerProcess
implements JMSBroker {
    private Broker broker = Broker.getBroker();

    private Properties convertArgs(String[] args) throws IllegalArgumentException {
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-varhome")) {
                props.setProperty("imq.varhome", args[i + 1]);
                ++i;
                continue;
            }
            if (arg.equals("-imqhome")) {
                props.setProperty("imq.home", args[i + 1]);
                ++i;
                continue;
            }
            if (!arg.equals("-libhome")) continue;
            props.setProperty("imq.libhome", args[i + 1]);
            ++i;
        }
        Globals.pathinit(props);
        return this.broker.convertArgs(args);
    }

    @Override
    public Properties parseArgs(String[] args) throws IllegalArgumentException {
        return this.convertArgs(args);
    }

    public boolean isRunning() {
        return true;
    }

    @Override
    public int start(boolean inProcess, Properties properties, BrokerEventListener bel, boolean initOnly, Throwable failStartThrowable) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        return this.broker.start(inProcess, properties, bel, initOnly, failStartThrowable);
    }

    @Override
    public void stop(boolean cleanup) throws IllegalStateException {
        Broker.destroyBroker(cleanup);
        this.broker = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isShutdown() {
        if (this.broker == null) return true;
        if (Broker.broker != null) return false;
        return true;
    }

    @Override
    public void addEmbeddedBrokerStartupMessage(String message) {
        this.broker.addEmbeddedBrokerStartupMessage(message);
    }
}

